# saveme.pl - safeperl CGI example program
#
# This is a simple safeperl CGI program that will either print a 
# blank form or validate a submitted form and append the results to
# a file.
#
# To use this program, you must copy it to your cgi/bin directory.
# Before using it for the first time, you'll have to create an empty
# file called cgi/out/results.txt. Once you've done this, you can invoke
# it via <http://users.ox.ac.uk/cgi-bin/safeperl/USERNAME/saveme.pl>.
#
# Ray Miller <raym@herald.ox.ac.uk>
#
# Copyright (C) 2001 University of Oxford
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# --> FILL IN YOUR USERNAME <---
my $ACTION = "http://users.ox.ac.uk/cgi-bin/safeperl/USERNAME/saveme.pl";
 
# The name of the results file (stored in ~cgi/out)
my $OUTPUT_FILE = "results.txt";

########################################################################
# Print a blank form for people to fill in
########################################################################
sub print_form {
    print <<"EOT";
Content-type: text/html

<html>
<head>
<title>Example Form</title>
</head>
<body>
<h1>Example Form</h1>
<form method="GET" action="$ACTION">
<p>
What is your name? <input type=text name=name size=40 maxsize=60>
</p>
<p>
<table>
<tr>
<th></th>
<th>1</th>
<th>2</th>
<th>3</th>
<th>4</th>
<th>5</th>
</tr>
<tr>
<td>How do you rate the book?</td>
<td><input type=radio name=book value=1></td>
<td><input type=radio name=book value=2></td>
<td><input type=radio name=book value=3 checked></td>
<td><input type=radio name=book value=4></td>
<td><input type=radio name=book value=5></td>
</tr>
<tr>
<td>How do you rate the film?</td>
<td><input type=radio name=film value=1></td>
<td><input type=radio name=film value=2></td>
<td><input type=radio name=film value=3 checked></td>
<td><input type=radio name=film value=4></td>
<td><input type=radio name=film value=5></td>
</tr>
</table>
</p>
<p>
<input type=submit name=submit value="Vote">
<input type=submit name=submit value="Show Results">
</p>
</form>
</body>
</html>
EOT
}

########################################################################
# Display an error message when the form isn't filled in properly
########################################################################
sub form_error {
    my $errors = shift;
    print<<"EOT";
Content-type: text/html

<html>
<head>
<title>Error in Form!</title>
</head>
<body>
<h1>Error in Form!</h1>
EOT
    foreach (@$errors) {
	print "<p>$_</p>\n";
    }
   print <<"EOT";
</body>
</html>
EOT
}

########################################################################
# Print the results so far
########################################################################
sub show_results {
    unless (open(RESULTS, "out/$OUTPUT_FILE")) {
	form_error(["Sorry, could not get hold of the results: $!"]);
	return;
    }
    print "Content-type: text/plain\n\n";
    while(<RESULTS>) {
	print;
    }
    close(RESULTS);
}

########################################################################
# Save the results to a file and print a message saying OK
########################################################################
sub save_results {
    my $query = shift;
    unless (open(RESULTS, ">>$OUTPUT_FILE")) {
	form_error(["Could not open file to save results!"]);
	return;
    }
    print RESULTS scalar(localtime) . ", $query->{name}, $query->{book}, $query->{film}\n";
    close(RESULTS);
    print <<"EOT";
Content-type: text/html

<html>
<head>
<title>Submitted OK</title>
</head>
<body>
<h1>Submitted OK</h1>
</body>
</html>
EOT
}

########################################################################
# Check that the name entered is valid (can only contain the characters
# A-Z, a-z, - and space, and must be between 1 and 60 characters long
########################################################################
sub isvalid_name {
    my $name = shift;
    return defined $name && $name =~ /^[ a-zA-z-]{1,60}$/;
}

########################################################################
# Check that a radio button choice is valid (must be 1-5)
########################################################################
sub isvalid_choice {
    my $choice = shift;
    return defined $choice && $choice =~ /^[1-5]$/;
}

########################################################################
# Check that the form was filled out properly
########################################################################
sub validate_query {
    my $query = shift;
    my @errors;
    push @errors, "Invalid name!" unless isvalid_name($query->{name});
    push @errors, "Invalid book!" unless isvalid_choice($query->{book});
    push @errors, "Invalid film!" unless isvalid_choice($query->{film});
    if (@errors) {
	form_error(\@errors);
	return 0;
    }
    return 1;
}

########################################################################
# The action starts here...
########################################################################

#  We call the parsed_query() function to get the fields from the
# submitted form. $query{name} is what they typed in the field called
# "name", $query{film} the value they chose for "film", etc.

my %query = parsed_query();

if (defined $query{submit}) {
    # If they pressed the submit button, see if they want to vote
    # or to see the results
    if ($query{submit} eq "Vote") {
	# check that the form was filled in properly and, if so, save 
	# the results
	validate_query(\%query) && save_results(\%query);
    }
    elsif ($query{submit} eq "Show Results") {
	# show them the results so far
	show_results();
    }
    else {
	# They're asking for something we don't understand
	form_error(["I don't understand option $form{submit}"]);
    }
}
else {
    # Otherwise (they haven't submitted the form), print a blank form
    # for them to fill in
    print_form();
}

# That's it!

exit 0;
